/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.updater;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import net.imagej.updater.Checksummer;
import net.imagej.updater.Dependency;
import net.imagej.updater.FileObject;
import net.imagej.updater.FilesCollection;
import net.imagej.updater.util.UpdaterUtil;

public class Conflicts {
    private final FilesCollection files;
    protected List<Conflict> conflicts;

    public Conflicts(FilesCollection files) {
        this.files = files;
    }

    public Iterable<Conflict> getConflicts(boolean forUpload) {
        this.conflicts = new ArrayList<Conflict>();
        if (!forUpload) {
            this.listUpdateIssues();
        } else {
            this.listUploadIssues();
        }
        return this.conflicts;
    }

    protected void listUpdateIssues() {
        FilesCollection.DependencyMap toInstall = this.files.getDependencies(false);
        FilesCollection.DependencyMap obsoleted = this.files.getDependencies(true);
        LinkedHashSet<FileObject> automatic = new LinkedHashSet<FileObject>();
        for (FileObject file : toInstall.keySet()) {
            if (obsoleted.get(file) != null) {
                this.conflicts.add(this.bothInstallAndUninstall(file, (FilesCollection)toInstall.get(file), (FilesCollection)obsoleted.get(file)));
                continue;
            }
            if (file.willBeUpToDate()) continue;
            if (file.isLocallyModified()) {
                if (this.files.ignoredConflicts.contains(file)) continue;
                this.conflicts.add(this.locallyModified(file, (FilesCollection)toInstall.get(file)));
                continue;
            }
            automatic.add(file);
        }
        for (FileObject file : obsoleted.keySet()) {
            if (toInstall.get(file) == null && file.willNotBeInstalled()) continue;
            this.conflicts.add(this.needUninstall(file, (FilesCollection)obsoleted.get(file)));
        }
        if (automatic.size() > 0) {
            for (FileObject file : automatic) {
                file.setFirstValidAction(this.files, FileObject.Action.UPDATE, FileObject.Action.INSTALL);
            }
            this.conflicts.add(new Notice("There are files which need to be updated/installed since other files depend on them:\n" + UpdaterUtil.join(", ", automatic)));
        }
    }

    protected Conflict bothInstallAndUninstall(FileObject file, FilesCollection installReasons, FilesCollection obsoleteReasons) {
        return new Conflict(Conflict.Severity.ERROR, file, "Required by \n\n" + installReasons + "\nbut made obsolete by\n\n" + obsoleteReasons, this.ignoreResolution("Ignore this issue", file), this.actionResolution("Do not update " + installReasons, installReasons, new FileObject.Action[0]));
    }

    protected Conflict needUninstall(FileObject file, FilesCollection obsoleteReasons) {
        return new Conflict(Conflict.Severity.ERROR, file, "Locally modified but made obsolete by\n\n" + obsoleteReasons, this.actionResolution("Uninstall " + file, file, FileObject.Action.UNINSTALL), this.actionResolution("Do not update " + obsoleteReasons, obsoleteReasons, new FileObject.Action[0]));
    }

    protected Conflict locallyModified(FileObject file, FilesCollection installReasons) {
        boolean toInstall = file.getStatus().isValid(FileObject.Action.INSTALL);
        return new Conflict(Conflict.Severity.WARNING, file, "Locally modified and the Updater cannot determine its status. A newer version might be required by\n\n" + installReasons, this.ignoreResolution("Keep the local version", file), this.actionResolution((toInstall ? "Install" : "Update") + " " + file, file, toInstall ? FileObject.Action.INSTALL : FileObject.Action.UPDATE));
    }

    protected void listUploadIssues() {
        FilesCollection.DependencyMap needsUpload = new FilesCollection.DependencyMap();
        for (FileObject file : this.files.toUpload()) {
            if (file.getTimestamp() != UpdaterUtil.getTimestamp(this.files.prefix(file))) {
                this.conflicts.add(this.timestampChanged(file));
            }
            for (Dependency dependency : file.getDependencies()) {
                FileObject dep = this.files.get(dependency.filename);
                if (dep == null || this.files.ignoredConflicts.contains(dep) || dep.getAction() == FileObject.Action.UPLOAD || !dep.isInstallable() && !dep.isLocalOnly() && !dep.isObsolete() && !dep.getStatus().isValid(FileObject.Action.UPLOAD)) continue;
                needsUpload.add(dep, file);
            }
            if (this.files.ignoredConflicts.contains(file) || !file.filename.endsWith(".jar")) continue;
            String baseName = file.getBaseName();
            int slash = baseName.lastIndexOf(47);
            String prefix = baseName.substring(0, slash + 1);
            baseName = baseName.substring(slash + 1);
            for (String name : this.files.prefix(file).getParentFile().list()) {
                String prefixed = prefix + name;
                if (!name.startsWith(baseName) || file.filename.equals(prefixed) || !file.getFilename(true).equals(FileObject.getFilename(prefixed, true))) continue;
                this.conflicts.add(this.conflictingVersions(file, this.files.prefix(prefixed), prefixed));
            }
        }
        for (FileObject file : needsUpload.keySet()) {
            this.conflicts.add(this.needUpload(file, (FilesCollection)needsUpload.get(file)));
        }
        HashSet<String> sites = new HashSet<String>(this.files.getSiteNamesToUpload());
        for (FileObject file : this.files.managedFiles()) {
            if (file.getAction() == FileObject.Action.REMOVE || file.isObsolete() || sites.size() > 0 && !sites.contains(file.updateSite)) continue;
            for (Dependency dependency : file.getDependencies()) {
                FileObject dependencyObject = this.files.get(dependency.filename);
                if (dependency.overrides) {
                    if (dependencyObject == null || dependencyObject.isObsolete() || dependencyObject.willNotBeInstalled()) continue;
                    this.conflicts.add(this.dependencyObsoleted(file, dependencyObject));
                    continue;
                }
                if (dependencyObject != null && dependencyObject.getAction() == FileObject.Action.UPLOAD) continue;
                if (dependencyObject == null || dependencyObject.getStatus() == FileObject.Status.LOCAL_ONLY) {
                    this.conflicts.add(this.dependencyNotUploaded(file, dependency.filename));
                    continue;
                }
                if (!dependencyObject.isObsolete() && (dependencyObject.getAction() != FileObject.Action.REMOVE || dependencyObject.overridesOtherUpdateSite())) continue;
                this.conflicts.add(this.dependencyRemoved(file, dependency.filename));
            }
        }
    }

    protected Conflict timestampChanged(final FileObject file) {
        return new Conflict(Conflict.Severity.ERROR, file, "The timestamp of " + file + " changed in the meantime", new Resolution("Recalculate checksum and dependencies of " + file){

            @Override
            public void resolve() {
                Checksummer checksummer = new Checksummer(Conflicts.this.files, null);
                checksummer.updateFromLocal(Collections.singletonList(file.getFilename()));
                Conflicts.this.files.updateDependencies(file);
            }
        });
    }

    protected Conflict needUpload(final FileObject file, final FilesCollection uploadReasons) {
        boolean localOnly = file.isLocalOnly();
        boolean notInstalled = file.isInstallable();
        boolean obsolete = file.isObsolete();
        ArrayList<Resolution> resolutions = new ArrayList<Resolution>();
        if (!localOnly && !obsolete) {
            resolutions.add(this.ignoreResolution("Do not upload " + file, file));
        }
        if (!notInstalled) {
            resolutions.add(this.actionResolution("Upload " + file + (obsolete ? " again" : ""), file, FileObject.Action.UPLOAD));
        }
        resolutions.add(new Resolution("Break the dependency"){

            @Override
            public void resolve() {
                for (FileObject other : uploadReasons) {
                    other.removeDependency(file.getFilename());
                }
            }
        });
        return new Conflict(localOnly || obsolete ? Conflict.Severity.CRITICAL_ERROR : Conflict.Severity.ERROR, file, (localOnly ? "Not uploaded yet" : "Is " + (notInstalled ? "not installed" : (obsolete ? "marked obsolete" : "locally modified"))) + " but a dependency of\n\n" + uploadReasons, resolutions.toArray(new Resolution[resolutions.size()]));
    }

    private Conflict dependencyObsoleted(final FileObject obsoleting, final FileObject obsoleted) {
        ArrayList<Resolution> resolutions = new ArrayList<Resolution>();
        resolutions.add(new Resolution("Do not obsolete " + obsoleted.getFilename()){

            @Override
            public void resolve() {
                obsoleting.removeDependency(obsoleted.getFilename());
            }
        });
        if (obsoleting.updateSite.equals(obsoleted.updateSite)) {
            resolutions.add(new Resolution("Remove " + obsoleted.getFilename() + " from the Update Site"){

                @Override
                public void resolve() {
                    obsoleted.setAction(Conflicts.this.files, FileObject.Action.REMOVE);
                    Conflicts.this.files.prefix(obsoleted).delete();
                }
            });
        }
        return new Conflict(Conflict.Severity.ERROR, obsoleted, "The file " + obsoleting.getFilename() + " overrides the file " + obsoleted.getFilename() + ", but " + obsoleted.getFilename() + " was not removed", resolutions.toArray(new Resolution[resolutions.size()]));
    }

    protected Conflict dependencyNotUploaded(FileObject file, String dependency) {
        return new Conflict(Conflict.Severity.ERROR, file, "Depends on " + dependency + " which was not uploaded.", this.dependencyResolution("Break the dependency", file, dependency, null));
    }

    protected Conflict dependencyRemoved(FileObject file, String dependency) {
        ArrayList<Resolution> resolutions = new ArrayList<Resolution>();
        resolutions.add(this.dependencyResolution("Break the dependency", file, dependency, null));
        for (FileObject toUpload : this.files.toUpload()) {
            if (file.hasDependency(toUpload.getFilename())) continue;
            resolutions.add(this.dependencyResolution("Replace with dependency to " + toUpload, file, dependency, toUpload.getFilename()));
            resolutions.add(this.dependencyResolution("Replace all dependencies on " + dependency + " with " + toUpload, null, dependency, toUpload.getFilename()));
        }
        return new Conflict(Conflict.Severity.ERROR, file, "Depends on " + dependency + " which is about to be removed.", resolutions.toArray(new Resolution[resolutions.size()]));
    }

    protected Conflict conflictingVersions(FileObject file, File otherFile, String otherFileName) {
        return new Conflict(Conflict.Severity.ERROR, file, "Conflicting version found: " + otherFileName, this.deleteFile("Delete " + otherFileName + " (dangerous!)", otherFile), this.ignoreResolution("Ignore the problem (also dangerous!)", file));
    }

    protected Resolution ignoreResolution(String description, final FileObject file) {
        return new Resolution(description){

            @Override
            public void resolve() {
                ((Conflicts)Conflicts.this).files.ignoredConflicts.add(file);
            }
        };
    }

    protected Resolution deleteFile(String description, final File file) {
        return new Resolution(description){

            @Override
            public void resolve() {
                file.delete();
            }
        };
    }

    protected Resolution actionResolution(String description, FileObject file, FileObject.Action ... actionsToTry) {
        return this.actionResolution(description, Collections.singleton(file), actionsToTry);
    }

    protected Resolution actionResolution(String description, final Iterable<FileObject> files, final FileObject.Action ... actionsToTry) {
        return new Resolution(description){

            @Override
            public void resolve() {
                for (FileObject file : files) {
                    file.setFirstValidAction(Conflicts.this.files, actionsToTry);
                }
            }
        };
    }

    protected Resolution dependencyResolution(String description, final FileObject file, final String removeDependency, final String addDependency) {
        return new Resolution(description){

            @Override
            public void resolve() {
                if (file != null) {
                    Conflicts.this.replaceDependency(file, removeDependency, addDependency);
                } else {
                    for (FileObject file2 : Conflicts.this.files) {
                        if (!file2.hasDependency(removeDependency)) continue;
                        Conflicts.this.replaceDependency(file2, removeDependency, addDependency);
                    }
                }
            }
        };
    }

    protected void replaceDependency(FileObject file, String removeDependency, String addDependency) {
        file.removeDependency(removeDependency);
        if (addDependency != null) {
            file.addDependency(addDependency, this.files.prefix(addDependency));
        }
    }

    public boolean hasDownloadConflicts() {
        this.conflicts = new ArrayList<Conflict>();
        this.listUpdateIssues();
        return this.conflicts.size() > 0;
    }

    public boolean hasUploadConflicts() {
        this.conflicts = new ArrayList<Conflict>();
        this.listUploadIssues();
        return this.conflicts.size() > 0;
    }

    public static boolean needsFeedback(Iterable<Conflict> conflicts) {
        if (conflicts == null) {
            return false;
        }
        for (Conflict conflict : conflicts) {
            if (conflict instanceof Notice) continue;
            return true;
        }
        return false;
    }

    public static abstract class Resolution {
        private final String description;

        public Resolution(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }

        public abstract void resolve();
    }

    public static class Notice
    extends Conflict {
        public Notice(String message) {
            super(Conflict.Severity.NOTICE, (String)null, message, new Resolution[0]);
        }
    }

    public static class Conflict {
        private final Severity severity;
        protected final String filename;
        private final String conflict;
        protected final Resolution[] resolutions;

        @Deprecated
        public Conflict(FileObject file, String conflict, Resolution ... resolutions) {
            this(Severity.ERROR, file, conflict, resolutions);
        }

        @Deprecated
        public Conflict(boolean isError, FileObject file, String conflict, Resolution ... resolutions) {
            this(isError ? Severity.ERROR : Severity.WARNING, file, conflict, resolutions);
        }

        @Deprecated
        public Conflict(boolean isError, boolean isCritical, FileObject file, String conflict, Resolution ... resolutions) {
            this(isCritical ? Severity.CRITICAL_ERROR : (isError ? Severity.ERROR : Severity.WARNING), file == null ? null : file.getFilename(), conflict, resolutions);
        }

        @Deprecated
        public Conflict(boolean isError, boolean isCritical, String filename, String conflict, Resolution ... resolutions) {
            this(isCritical ? Severity.CRITICAL_ERROR : (isError ? Severity.ERROR : Severity.WARNING), filename, conflict, resolutions);
        }

        public Conflict(Severity severity, FileObject file, String conflict, Resolution ... resolutions) {
            this(severity, file == null ? null : file.getFilename(), conflict, resolutions);
        }

        public Conflict(Severity severity, String filename, String conflict, Resolution ... resolutions) {
            this.severity = severity;
            this.filename = filename;
            this.conflict = conflict;
            this.resolutions = resolutions;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public boolean isError() {
            return this.severity.compareTo(Severity.ERROR) <= 0;
        }

        public boolean isCritical() {
            return this.severity.compareTo(Severity.CRITICAL_ERROR) <= 0;
        }

        public String getFilename() {
            return this.filename;
        }

        public String getConflict() {
            return this.conflict;
        }

        public Resolution[] getResolutions() {
            return this.resolutions;
        }

        public String toString() {
            return this.getFilename() + ": " + this.getConflict();
        }

        public static enum Severity {
            CRITICAL_ERROR,
            ERROR,
            WARNING,
            NOTICE;


            public String toString() {
                return UpdaterUtil.toCamelCase(this.name());
            }
        }
    }
}

